import java.util.HashMap;
import java.util.Map;

import net.catcert.DigitalSignatureServiceStub;

import org.apache.xmlbeans.XmlOptions;
import org.w3.www._2000._09.xmldsig.DigestMethodType;

import schema.core._0._1.dss.tc.names.oasis.SignatureObjectType;
import schema.core._0._1.dss.tc.names.oasis.VerifyRequestDocument;
import schema.core._0._1.dss.tc.names.oasis.VerifyResponseDocument;
import schema.core._0._1.dss.tc.names.oasis.DocumentHashDocument.DocumentHash;
import schema.core._0._1.dss.tc.names.oasis.InputDocumentsDocument.InputDocuments;
import schema.core._0._1.dss.tc.names.oasis.OptionalInputsDocument.OptionalInputs;
import schema.core._0._1.dss.tc.names.oasis.VerifyRequestDocument.VerifyRequest;

import com.bs.psis.test.utils.Utils;

/**
 * Valida un certificat
 * 
 * @author Toni Llebaria
 * 
 */
public class ValidacioXMLdetachedAmbHash {

	/**
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception {

		// Configuraci socket TSL
		// Client keystore init
		System.setProperty("javax.net.ssl.keyStore","C:\\psisauth.p12");
		// Here we define the type of keystore jks, pkcs12 or the one containing the user keys
		System.setProperty("javax.net.ssl.keyStoreType","pkcs12");
		// The keystore password
		System.setProperty("javax.net.ssl.keyStorePassword", "sIikZSmz");

		// Cert must be added to cacerts using keytool or specified here
		System.setProperty("javax.net.ssl.trustStore","C:\\Program Files\\Java\\jre1.5.0_14\\lib\\security\\cacerts_pre");
		System.setProperty("javax.net.ssl.trustStoreType", "JKS");
		System.setProperty("javax.net.ssl.trustStorePassord", "changeit");
		//System.setProperty("javax.net.debug", "ssl");

		// Security Provider
		System.setProperty("java.protocol.handler.pkgs","com.sun.net.ssl.internal.www.protocol");
		Security.addProvider(new com.sun.net.ssl.internal.ssl.Provider());
		XmlOptions options = new XmlOptions();

		Map namespacePrefixes = new HashMap();
		namespacePrefixes.put("xss", "urn:oasis:names:tc:dss:1.0:profiles:XSS");
		namespacePrefixes.put("dss", "urn:oasis:names:tc:dss:1.0:core:schema");
		namespacePrefixes.put("ds", "http://www.w3.org/2000/09/xmldsig#");
		options.setSaveSuggestedPrefixes(namespacePrefixes);

		VerifyRequestDocument requestDocument = VerifyRequestDocument.Factory.newInstance(options);
		VerifyRequest request = requestDocument.addNewVerifyRequest();
		request.setProfile("urn:oasis:names:tc:dss:1.0:profiles:XSS");

		//Llegim la signatura i el doc
		String signature = Utils.readXmlFile("document_0_signat.xml");
		byte[] hash = Utils.readBase64File("hash4.dat");
		
		// Creaci de l'element amb la signatura XML a verificar
		SignatureObjectType signaturetype = SignatureObjectType.Factory.parse(signature,options);
		request.setSignatureObject(signaturetype);		
		
		// Creaci de l'element amb el document signat
		InputDocuments inpDocuments = request.addNewInputDocuments();		
		DocumentHash hashDoc = inpDocuments.addNewDocumentHash();
		DigestMethodType digestMethod = hashDoc.addNewDigestMethod();
		digestMethod.setAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
		hashDoc.setDigestValue(hash);
		hashDoc.setRefURI("DetachedObjectReference-1");
		
		// Creaci de l'element amb els parmetres opcionals a consultar
		OptionalInputs optional = request.addNewOptionalInputs();

		// Detalls del resultat de validaci
		optional.addNewReturnProcessingDetails();
		optional.addNewReturnSignedResponse();

		// Execuci del servei
		DigitalSignatureServiceStub digitalSignatureServiceStub = new DigitalSignatureServiceStub("http://psisbeta.catcert.net/psis/catcert-test/dss");
		requestDocument = VerifyRequestDocument.Factory.parse(requestDocument.newInputStream());		

		// Visualitzaci de la petici
		System.out.println(requestDocument.xmlText());

		VerifyResponseDocument responseDocument = digitalSignatureServiceStub.verify(requestDocument);
				
		// visualitzaci de la resposta
		System.out.println("\n\n\nResposta:\n" + responseDocument.xmlText());
	}
}